//
//  RMErrorViewController.h
//  RMAppKit
//
//  Created by Keith Duncan on 25/04/2011.
//  Copyright 2011 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "RMFoundation/RMFoundation.h"

@class RMErrorRecoveryAttempter;

extern NSString *const RMAlertViewControllerDidPresentErrorNotificationName;
	extern NSString *const RMAlertViewControllerDidPresentErrorDidRecoverKey; // [NSNumber boolValue]

@interface RMAlertViewController : NSViewController

typedef RM_ENUM(NSUInteger, RMAlertViewControllerStyle) {
	RMAlertViewControllerStyleDefault = 0,
	RMAlertViewControllerStyleTextOnly,
};
/*!
	\brief
	Designated Initialiser.
	
	\details
	`RMErrorViewControllerStyleDefault` is drawn like an NSAlert including the recovery buttons
	`RMErrorViewControllerStyleTextOnly` only draws the text
 */
- (id)initWithError:(NSError *)error style:(RMAlertViewControllerStyle)style;

@property (readonly, retain, nonatomic) NSError *error;
@property (readonly, assign, nonatomic) RMAlertViewControllerStyle style;

/*!
	\brief
	Used as the caution badge.
 */
@property (retain, nonatomic) NSImage *icon;

/*!
	\brief
	If set, these cells are sent -copy for use in the interface, otherwise a standard button cell is used.
 */
@property (retain, nonatomic) NSButtonCell *defaultButtonCell, *standardButtonCell;

/*!
	\brief
	If nil, the recovery attempter provided with the error is used.
	This property can override the error provided recovery attempter.
 */
@property (retain, nonatomic) RMErrorRecoveryAttempter *recoveryAttempter;

/*
	
 */

@property (readonly, assign, nonatomic) IBOutlet NSView *contentContainerView;

@property (readonly, assign, nonatomic) IBOutlet NSImageView *cautionImageView, *cautionBadgeImageView;

@property (readonly, assign, nonatomic) IBOutlet NSTextField *localizedDescriptionTextField;
@property (readonly, assign, nonatomic) IBOutlet NSTextField *localizedRecoverySuggestionTextField;

@property (readonly, assign, nonatomic) IBOutlet NSView *bottomBarContainerView;
@property (readonly, assign, nonatomic) IBOutlet NSImageView *bottomBarDividerImageView;

@property (readonly, assign, nonatomic) IBOutlet NSButton *primaryButton;
- (IBAction)primaryAction:(id)sender;

- (IBAction)recoveryAction:(id)sender;

@end
